function cb_m41 
% Menu 41
% Guitar load

  global persParamsDir                
  global Rv                   
  global Rt
  global Ct
  global isGitLoad
  global sfontsize
  global m41
  
  kw=20/sfontsize;
  capt = get(m41,'label');  
  rowscols = [1,30*kw; 1,30*kw; 1,30*kw,; 1, 30*kw];
  prompt={};  
  prompt{1} = 'Rv / kOhm';
  prompt{2} = 'Rt / kOhm';
  prompt{3} = 'Ct / nF';
  prompt{4} = 'Regard guitar load? (0 = no, 1 = yes)'; 
  defaults{1} = num2str(Rv/1000,4);
  defaults{2} = num2str(Rt/1000,4);
  defaults{3} = num2str(Ct/1e-9,4);
  defaults{4} = num2str(isGitLoad); 
  
  result= inputdlg (prompt, capt, rowscols, defaults);
  
  if ~isempty(result) 
    num=real(str2num(result{1})); 
    if ~isempty(num)   
      Rv=num(1,1)*1000;
      if (Rv < 100) Rv = 100; end
      if (Rv > 10e9) Rv = 10e9; end 
    end 
    num=real(str2num(result{2})); 
    if ~isempty(num)        
      Rt=num(1,1)*1000;
      if (Rt < 100) Rt = 100; end
      if (Rt > 10e9) Rt = 10e9; end 
     end 
    num=real(str2num(result{3})); 
    if ~isempty(num)        
      Ct=num(1,1)*1e-9;
      if (Ct < 1e-12) Ct = 1e-12; end
      if (Ct > 1e-3) Ct = 1e-3; end 
    end 
    num=real(str2num(result{4})); 
    if ~isempty(num)        
      isGitLoad=num(1,1);
      if (isGitLoad <0.5) isGitLoad = false; end
      if (isGitLoad >= 0.5) isGitLoad = true; end 
    end
    sn = strcat(persParamsDir,'gitParams.mat');
    save('-mat',sn, 'Rv', 'Rt' , 'Ct', 'isGitLoad');
  end  
  
end